DEFINT A-Z
'$INCLUDE: '64blaz.bi'
DECLARE SUB Backscroll ()           'View the backscroll buffer
DECLARE SUB AddBackScroll (RowNum%) 'Add a line to the backscroll buffer
DECLARE SUB TTYStay (Char%, Attr%)
DECLARE SUB Load64Set (Set%)
DECLARE SUB GetaKey (Keyy$)
DECLARE FUNCTION CCap$ (Strg$)
CONST BuffLines% = 400       'The size of the backscroll buffer
DIM SHARED LineBuff AS STRING * 80
DIM SHARED BackBuff(BuffLines%) AS STRING * 80



SUB AddBackScroll (RowNum%)
  IF Buff% = 0 THEN EXIT SUB
  GetBlock VARSEG(BackBuff(BackLine%)), VARPTR(BackBuff(BackLine%)), Row%, 1, 1, 40
  BackLine% = (BackLine% + 1) MOD BuffLines%
END SUB

SUB Backscroll STATIC
  COLOR , 0
  CLS
  BCl% = 0
  BBg% = 15
  ClrBg% = 10
  Top% = 1
  Bot% = 23
  ScrLeng% = Bot% - Top% + 1
  CurrRow% = BackLine%
  Resett% = -1
  DO
    IF Resett% THEN
      Print64 24, 1, "{@}O    up/down:scroll           esc:exit   "
      Print64 25, 1, "  ctrl-home:erase buffer                "
      KeyP$ = CHR$(0) + CHR$(0)
      Resett% = 0
    END IF
    IF LEFT$(KeyP$, 1) = CHR$(0) THEN
      KeyP$ = RIGHT$(KeyP$, 1)
      SELECT CASE KeyP$
      CASE "I", "Q", CHR$(0)  'PageDown or PageUp or Reset screen
        IF KeyP$ = "Q" THEN
          FOR MLine% = 1 TO ScrLeng%
            IF CurrRow% = BackLine% THEN EXIT FOR
            CurrRow% = (CurrRow% + 1) MOD BuffLines%
          NEXT
        ELSEIF KeyP$ = "I" THEN
          FOR MLine% = 1 TO ScrLeng%
            IF (CurrRow% - ScrLeng% + BuffLines%) MOD BuffLines% = BackLine% THEN EXIT FOR
            CurrRow% = (CurrRow% - 1 + BuffLines%) MOD BuffLines%
          NEXT
        END IF
        FOR PrintIt% = Top% TO Bot%
          LineNum% = (CurrRow% - ScrLeng% + PrintIt% - 1 + BuffLines%) MOD BuffLines%
          PutBlock VARSEG(BackBuff(LineNum%)), VARPTR(BackBuff(LineNum%)), PrintIt%, 1, 1, 40
        NEXT PrintIt%
      CASE "H"  'Cursor up
        IF (CurrRow% - ScrLeng% + BuffLines%) MOD BuffLines% <> BackLine% THEN
          CurrRow% = (CurrRow% - 1 + BuffLines%) MOD BuffLines%
          Regs.ax = &H701
          Regs.bx = VAL("&H" + HEX$(BBack% * 4096& + BFore% * 256&))
          Regs.cx = (Top% - 1) * 256 + 0
          Regs.dx = (Bot% - 1) * 256 + 39
          interrupt &H10, Regs, Regs
          LineNum% = (CurrRow% - ScrLeng% + Top% - 1 + BuffLines%) MOD BuffLines%
          PutBlock VARSEG(BackBuff(LineNum%)), VARPTR(BackBuff(LineNum%)), Top%, 1, 1, 40
        END IF
      CASE "P"  'Cursor down
        IF CurrRow% <> BackLine% THEN
          CurrRow% = (CurrRow% + 1) MOD BuffLines%
          Regs.ax = &H601
          Regs.bx = VAL("&H" + HEX$(BBack% * 4096& + BFore% * 256&))
          Regs.cx = (Top% - 1) * 256 + 0
          Regs.dx = (Bot% - 1) * 256 + 39
          interrupt &H10, Regs, Regs
          LineNum% = (CurrRow% - ScrLeng% + Bot% - 1 + BuffLines%) MOD BuffLines%
          PutBlock VARSEG(BackBuff(LineNum%)), VARPTR(BackBuff(LineNum%)), Bot%, 1, 1, 40
        END IF
      CASE ""     'Shift-Tab Change character sets
        Set% = Set% XOR 1
        Load64Set Set%
        KeyP$ = ""
      CASE "w"
        Print64 24, 1, "{@}J                                        "
        Print64 25, 1, CCap$("     erase buffer: are you sure? y/n    ")
        GetaKey ClrBuff$
        IF UCASE$(ClrBuff$) = "Y" THEN
          FOR Clearr% = 0 TO BuffLines%
            BackBuff(Clearr%) = STRING$(80, 0)
          NEXT Clearr%
          BackLine% = 0
        END IF
        Resett% = -1
      END SELECT
    END IF
    KeyP$ = INKEY$
  LOOP UNTIL KeyP$ = CHR$(27)

END SUB

